<?php

namespace App\Http\Controllers;

use App\Models\MiembroFamilia;
use Illuminate\Http\Request;

class MiembroFamiliaController extends Controller
{
    public function index()
    {
        return MiembroFamilia::with('familia')->get();
    }

    public function store(Request $request)
    {
        $request->validate([
            'familia_id' => 'required|exists:familias,id',
            'nombre' => 'required|string',
            'rol_familiar' => 'required|string',
            'sexo' => 'nullable|string',
            'foto' => 'nullable|string',
        ]);

        $data = $request->all();

        if ($request->has('foto')) {
            $data['foto'] = $this->saveBase64Image($request->foto, 'miembros');
        }

        $miembro = MiembroFamilia::create($data);

        return response()->json([
            'message' => 'Miembro agregado exitosamente',
            'miembro' => $miembro
        ], 201);
    }

    public function show($id)
    {
        return MiembroFamilia::findOrFail($id);
    }

    public function update(Request $request, $id)
    {
        $miembro = MiembroFamilia::findOrFail($id);
        
        $data = $request->all();

        if ($request->has('foto')) {
            $data['foto'] = $this->saveBase64Image($request->foto, 'miembros');
        }

        $miembro->update($data);
        
        return response()->json([
            'message' => 'Miembro actualizado',
            'miembro' => $miembro
        ]);
    }

    public function destroy($id)
    {
        $miembro = MiembroFamilia::findOrFail($id);
        $miembro->delete();
        
        return response()->json(['message' => 'Miembro eliminado']);
    }
}
