<?php

namespace App\Http\Controllers;

use App\Models\Sucursal;
use Illuminate\Http\Request;

class SucursalController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $query = Sucursal::query();

        if ($request->has('eliminado') && $request->eliminado === 'true') {
            $query->where('status', 'eliminado');
        } else {
            $query->where('status', '!=', 'eliminado');
        }

        return $query->get();
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'nombre' => 'required|string|max:255',
            'direccion' => 'required|string|max:255',
            'telefono' => 'nullable|string|max:20',
            'encargado' => 'nullable|string|max:255',
            'status' => 'required|in:activo,inactivo',
        ]);

        $sucursal = Sucursal::create($request->all());

        return response()->json([
            'message' => 'Sucursal creada exitosamente',
            'sucursal' => $sucursal
        ], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $sucursal = Sucursal::find($id);

        if (!$sucursal) {
            return response()->json(['message' => 'Sucursal no encontrada'], 404);
        }

        return $sucursal;
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $sucursal = Sucursal::find($id);

        if (!$sucursal) {
            return response()->json(['message' => 'Sucursal no encontrada'], 404);
        }

        $request->validate([
            'nombre' => 'sometimes|string|max:255',
            'direccion' => 'sometimes|string|max:255',
            'telefono' => 'nullable|string|max:20',
            'encargado' => 'nullable|string|max:255',
            'status' => 'sometimes|in:activo,inactivo,eliminado',
        ]);

        $sucursal->update($request->all());

        return response()->json([
            'message' => 'Sucursal actualizada correctamente',
            'sucursal' => $sucursal
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $sucursal = Sucursal::find($id);

        if (!$sucursal) {
            return response()->json(['message' => 'Sucursal no encontrada'], 404);
        }

        $sucursal->status = 'eliminado';
        $sucursal->save();

        return response()->json(['message' => 'Sucursal eliminada']);
    }
}
