<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Familia extends Model
{
    use HasFactory;

    protected $fillable = [
        'identificador',
        'nombre',
        'apellidos',
        'telefono',
        'address',
        'email',
        'foto',
    ];

    // Relación con los miembros
    public function miembros()
    {
        return $this->hasMany(MiembroFamilia::class);
    }

    // Generador automático de identificador (Boot)
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($familia) {
            if (empty($familia->identificador)) {
                // Genera FAM- seguido de 7 números aleatorios
                // Verifica que no exista (bucle simple)
                do {
                    $code = 'FAM-' . str_pad(mt_rand(1, 9999999), 7, '0', STR_PAD_LEFT);
                } while (self::where('identificador', $code)->exists());
                
                $familia->identificador = $code;
            }
        });
    }
}
