<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $this->call(PermissionSeeder::class);
        
        // Crear un rol de admin para el usuario por defecto
        $adminRole = \App\Models\Role::create(['nombre' => 'Admin', 'descripcion' => 'Administrador del sistema']);
        $vendedorRole = \App\Models\Role::create(['nombre' => 'Vendedor', 'descripcion' => 'Vendedor de punto de venta']);
        
        // User::factory(10)->create();

        User::create([
            'usuario' => 'admin',
            'contrasena' => 'admin123', // El modelo se encarga de hashear
            'role_id' => $adminRole->id,
            'status' => 'activo',
        ]);
    }
}
